/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWEventDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWSchema;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.property.VWBaseStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWInvokeParamPanel;
import filenet.vw.toolkit.runtime.property.VWReceiveParamPanel;
import filenet.vw.toolkit.runtime.property.VWReplyParamPanel;
import filenet.vw.toolkit.runtime.property.VWStepPropTabPanel;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWFunctionStrings;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableHeaderRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class VWSystemStepGeneralPanel
extends VWStepPropTabPanel
implements ListSelectionListener {
    private VWMapNode m_mapNode;
    private VWInstructionDefinition[] m_functions;
    private JList m_functionList;
    private DefaultListModel m_functionListModel;
    VWToolbarBorder m_functionPropertyBorder = null;
    private JPanel m_functionPropertyPanel = null;
    private DefaultTableCellRenderer m_tableCellRenderer = null;
    private ImageIcon m_waitedForWorkflowIcon = null;
    private Insets noInsets = new Insets(0, 0, 0, 0);
    private Insets insets = new Insets(0, 6, 0, 0);
    private JPanel m_noPropPanel = null;
    private JPanel m_assignPanel = null;
    private VWTable m_assignTable = null;
    private AssignTableModel m_assignTableModel = null;
    private String[] m_assignColumnNames = new String[]{VWResource.s_name, VWResource.s_expression};
    private JPanel m_beginTimerPanel = null;
    private JTextField m_beginTimerName = null;
    private JTextField m_beginTimerExpirationTime = null;
    private JTextField m_beginTimerMap = null;
    private JPanel m_dbExecutePanel = null;
    private JTextField m_dbConnectionAliasName = null;
    private JTextField m_dbProcedureName = null;
    private JList m_dbExecuteParameterList = null;
    private JPanel m_callPanel = null;
    private JTextField m_callMap = null;
    private JPanel m_createPanel = null;
    private VWTable m_createAssignTable = null;
    private JTextField m_createName = null;
    private AssignTableModel m_createAssignTableModel = null;
    private String[] m_createAssignColumnNames = new String[]{VWResource.s_name, VWResource.s_expression};
    private JPanel m_delayPanel = null;
    private JTextField m_delayTimeToDelay = null;
    private JPanel m_endTimerPanel = null;
    private JTextField m_endTimerName = null;
    private JPanel m_resumeTimerPanel = null;
    private JTextField m_resumeTimerName = null;
    private JPanel m_returnPanel = null;
    private JTextField m_returnRetry = null;
    private JPanel m_suspendTimerPanel = null;
    private JTextField m_suspendTimerName = null;
    private JPanel m_rollbackCheckPointPanel = null;
    private JTextField m_rollbackResumeProcessingValue = null;
    private JList m_rolledBackUserFields = null;
    private JList m_nonRolledBackUserFields = null;
    private JTextField m_rollbackMap = null;
    private VWFieldDefinition[] m_allDataFields = null;
    private JPanel m_executePanel = null;
    private JTextField m_executeQueueName = null;
    private JTextField m_executeOperationName = null;
    private JList m_executeParameterList = null;
    private JPanel m_logPanel = null;
    private JTextField m_eventType = null;
    private JTextField m_eventMessage = null;
    private static final int EVENT_NUMBER = 0;
    private static final int EVENT_WORKFLOW_NAME = 1;
    private static final int EVENT_CONDITION = 2;
    private String[] m_eventTableColumnNames = new String[]{VWResource.s_poundSign, VWResource.s_workflow, VWResource.s_condition};
    private JPanel m_waitForEventPanel = null;
    private JTextField m_waitForEventTimeout = null;
    private JTextField m_resultDataField = null;
    private VWTable m_waitForEventEventTable = null;
    private AbstractTableModel m_waitForEventEventTableModel = null;
    private VWEventDefinition[] m_waitForEventEvents = null;
    private JTextField m_waitForEventMap = null;
    private VWTable m_waitForEventAssignTable = null;
    private AssignTableModel m_waitForEventAssignTableModel = null;
    private static String ATTACH_BY_VALUE = null;
    private static String ATTACH_BY_VALUE_ARRAY = null;
    private static final String ARRAY = "[ ]";
    VWInvokeParamPanel m_invokeParamPanel = null;
    VWReceiveParamPanel m_receiveParamPanel = null;
    VWReplyParamPanel m_replyParamPanel = null;

    public VWSystemStepGeneralPanel(Frame parentFrame, VWBaseStepPropPanel propPanel) {
        super(parentFrame, propPanel);
        this.m_type = 1;
        this.preSetupLayout();
    }

    protected void initData() throws Exception {
        if (this.isInitialized()) {
            return;
        }
        try {
            if (this.m_step != null) {
                this.m_mapNode = this.m_step.getMapNode();
                this.m_functions = this.m_mapNode instanceof VWCompoundStepDefinition ? ((VWCompoundStepDefinition)this.m_mapNode).getInstructions() : null;
            } else {
                this.m_mapNode = null;
                this.m_functions = null;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
    }

    protected void preSetupLayout() {
        VWToolbarBorder functionBorder = new VWToolbarBorder(VWResource.s_functions, 0);
        JPanel functionPanel = functionBorder.getClientPanel();
        functionPanel.setLayout(new BorderLayout());
        this.m_functionList = new JList();
        JScrollPane scrollPane = new JScrollPane(this.m_functionList);
        scrollPane.setPreferredSize(new Dimension(10, 50));
        functionPanel.add((Component)scrollPane, "Center");
        this.m_functionList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
                if (value != null && value instanceof VWInstructionDefinition) {
                    this.setText(VWFunctionStrings.getLocalizedString(((VWInstructionDefinition)value).getAction()));
                } else {
                    this.setText(null);
                }
                return this;
            }
        });
        this.m_functionPropertyBorder = new VWToolbarBorder(VWResource.s_functionProperties, 0);
        this.m_functionPropertyPanel = this.m_functionPropertyBorder.getClientPanel();
        this.m_functionPropertyPanel.setLayout(new BorderLayout());
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 3.0;
        c.insets = new Insets(0, 4, 0, 4);
        this.add((Component)functionBorder, c);
        ++c.gridy;
        c.weighty = 7.0;
        this.add((Component)this.m_functionPropertyBorder, c);
        this.m_functionList.addListSelectionListener(this);
        this.m_tableCellRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
                ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
                component.applyComponentOrientation(compOrientation);
                String string = null;
                ((JLabel)component).setText("");
                ((JLabel)component).setIcon(null);
                if (compOrientation.isLeftToRight()) {
                    ((JLabel)component).setHorizontalAlignment(2);
                } else {
                    ((JLabel)component).setHorizontalAlignment(4);
                }
                if (value != null) {
                    if (value instanceof Integer) {
                        string = ((Integer)value).toString();
                        ((JLabel)component).setText(string);
                        ((JLabel)component).setHorizontalAlignment(0);
                    } else if (value instanceof JLabel) {
                        string = ((JLabel)value).getText();
                        ((JLabel)component).setIcon(((JLabel)value).getIcon());
                        ((JLabel)component).setText(string);
                        ((JLabel)component).setHorizontalAlignment(((JLabel)value).getHorizontalAlignment());
                    } else if (value instanceof String) {
                        string = (String)value;
                        ((JLabel)component).setText(string);
                    }
                }
                if (component != null && component instanceof JComponent) {
                    ((JComponent)component).setToolTipText(VWStringUtils.formatToolTip(string, 0));
                }
                return component;
            }
        };
    }

    protected void setupLayout() {
        this.updateDisplay();
    }

    protected void updateDisplay() {
        if (this.m_mapNode != null) {
            // empty if block
        }
        if (this.m_mapNode instanceof VWCompoundStepDefinition) {
            this.initFunctionModel();
            this.m_functionList.setModel(this.m_functionListModel);
            if (this.m_functionListModel.getSize() > 0) {
                this.m_functionList.setSelectedIndex(0);
            } else {
                this.m_functionList.setSelectedIndex(-1);
            }
            this.m_functionList.updateUI();
        }
    }

    private void updateFunctionPropertyPanel() {
        JPanel panel;
        block57: {
            block56: {
                Object obj = this.m_functionList.getSelectedValue();
                VWInstructionDefinition instruction = null;
                String borderTitle = VWResource.s_functionProperties;
                panel = null;
                if (obj == null || !(obj instanceof VWInstructionDefinition)) break block56;
                instruction = (VWInstructionDefinition)obj;
                int action = instruction.getAction();
                borderTitle = VWFunctionStrings.getLocalizedString(action);
                this.m_functionPropertyBorder.setTitle(borderTitle);
                switch (action) {
                    case 0: {
                        if (this.m_assignPanel == null) {
                            this.setupAssignPanel();
                        }
                        if (this.m_assignPanel != null) {
                            this.updateAssignPanel(instruction);
                            panel = this.m_assignPanel;
                            break;
                        }
                        break block57;
                    }
                    case 1: {
                        if (this.m_beginTimerPanel == null) {
                            this.setupBeginTimerPanel();
                        }
                        if (this.m_beginTimerPanel != null) {
                            this.updateBeginTimerPanel(instruction);
                            panel = this.m_beginTimerPanel;
                            break;
                        }
                        break block57;
                    }
                    case 37: {
                        if (this.m_dbExecutePanel == null) {
                            this.setupDbExecutePanel();
                        }
                        if (this.m_dbExecutePanel != null) {
                            this.updateDbExecutePanel(instruction);
                            panel = this.m_dbExecutePanel;
                            break;
                        }
                        break block57;
                    }
                    case 5: {
                        if (this.m_callPanel == null) {
                            this.setupCallPanel();
                        }
                        if (this.m_callPanel != null) {
                            this.updateCallPanel(instruction);
                            panel = this.m_callPanel;
                            break;
                        }
                        break block57;
                    }
                    case 6: {
                        if (this.m_createPanel == null) {
                            this.setupCreatePanel();
                        }
                        if (this.m_createPanel != null) {
                            this.updateCreatePanel(instruction);
                            panel = this.m_createPanel;
                            break;
                        }
                        break block57;
                    }
                    case 7: {
                        if (this.m_delayPanel == null) {
                            this.setupDelayPanel();
                        }
                        if (this.m_delayPanel != null) {
                            this.updateDelayPanel(instruction);
                            panel = this.m_delayPanel;
                            break;
                        }
                        break block57;
                    }
                    case 14: {
                        if (this.m_returnPanel == null) {
                            this.setupReturnPanel();
                        }
                        if (this.m_returnPanel != null) {
                            this.updateReturnPanel(instruction);
                            panel = this.m_returnPanel;
                            break;
                        }
                        break block57;
                    }
                    case 9: {
                        if (this.m_endTimerPanel == null) {
                            this.setupEndTimerPanel();
                        }
                        if (this.m_endTimerPanel != null) {
                            this.updateEndTimerPanel(instruction);
                            panel = this.m_endTimerPanel;
                            break;
                        }
                        break block57;
                    }
                    case 13: {
                        if (this.m_resumeTimerPanel == null) {
                            this.setupResumeTimerPanel();
                        }
                        if (this.m_resumeTimerPanel != null) {
                            this.updateResumeTimerPanel(instruction);
                            panel = this.m_resumeTimerPanel;
                            break;
                        }
                        break block57;
                    }
                    case 29: {
                        if (this.m_rollbackCheckPointPanel == null) {
                            this.setupRollbackCheckPointPanel();
                        }
                        if (this.m_rollbackCheckPointPanel != null) {
                            this.updateRollbackCheckPointPanel(instruction);
                            panel = this.m_rollbackCheckPointPanel;
                            break;
                        }
                        break block57;
                    }
                    case 16: {
                        if (this.m_suspendTimerPanel == null) {
                            this.setupSuspendTimerPanel();
                        }
                        if (this.m_suspendTimerPanel != null) {
                            this.updateSuspendTimerPanel(instruction);
                            panel = this.m_suspendTimerPanel;
                            break;
                        }
                        break block57;
                    }
                    case 23: {
                        if (this.m_executePanel == null) {
                            this.setupExecutePanel();
                        }
                        if (this.m_executePanel != null) {
                            this.updateExecutePanel(instruction);
                            panel = this.m_executePanel;
                            break;
                        }
                        break block57;
                    }
                    case 19: {
                        if (this.m_waitForEventPanel == null) {
                            this.setupWaitForEventPanel();
                        }
                        if (this.m_waitForEventPanel != null) {
                            this.updateWaitForEventPanel(instruction);
                            panel = this.m_waitForEventPanel;
                            break;
                        }
                        break block57;
                    }
                    case 39: {
                        if (this.m_invokeParamPanel == null) {
                            this.m_invokeParamPanel = new VWInvokeParamPanel(this, this.m_tableCellRenderer, instruction);
                        }
                        if (this.m_invokeParamPanel != null) {
                            this.m_invokeParamPanel.setInstructionDefinition(instruction);
                            panel = this.m_invokeParamPanel;
                            break;
                        }
                        break block57;
                    }
                    case 40: {
                        if (this.m_receiveParamPanel == null) {
                            this.m_receiveParamPanel = new VWReceiveParamPanel(this, this.m_tableCellRenderer, instruction);
                        }
                        if (this.m_receiveParamPanel != null) {
                            this.m_receiveParamPanel.setInstructionDefinition(instruction);
                            panel = this.m_receiveParamPanel;
                            break;
                        }
                        break block57;
                    }
                    case 41: {
                        if (this.m_replyParamPanel == null) {
                            this.m_replyParamPanel = new VWReplyParamPanel(this, this.m_tableCellRenderer, instruction);
                        }
                        if (this.m_replyParamPanel != null) {
                            this.m_replyParamPanel.setInstructionDefinition(instruction);
                            panel = this.m_replyParamPanel;
                            break;
                        }
                        break block57;
                    }
                    case 38: {
                        if (this.m_logPanel == null) {
                            this.setupLogPanel();
                        }
                        if (this.m_logPanel != null) {
                            this.updateLogPanel(instruction);
                            panel = this.m_logPanel;
                            break;
                        }
                        break block57;
                    }
                    default: {
                        borderTitle = VWResource.s_functionProperties;
                    }
                    case 8: 
                    case 17: 
                    case 27: 
                    case 28: 
                    case 42: {
                        if (this.m_noPropPanel == null) {
                            this.setupNoPropPanel();
                        }
                        panel = this.m_noPropPanel;
                        break;
                    }
                }
                break block57;
            }
            panel = null;
        }
        this.m_functionPropertyPanel.removeAll();
        if (panel != null) {
            this.m_functionPropertyPanel.add(panel, "Center");
        }
        this.m_functionPropertyPanel.updateUI();
    }

    private void setupAssignPanel() {
        this.m_assignPanel = new JPanel();
        this.m_assignPanel.setLayout(new BorderLayout());
        this.m_assignTable = new VWTable();
        this.m_assignPanel.add((Component)new JScrollPane(this.m_assignTable), "Center");
    }

    private void updateAssignPanel(VWInstructionDefinition instruction) {
        String[][] assignments = VWInstruction.AssignInstructionGetAssignment(instruction);
        if (this.m_assignTableModel == null) {
            this.m_assignTableModel = new AssignTableModel(assignments);
            this.m_assignTable.setModel(this.m_assignTableModel);
            TableColumnModel columnModel = this.m_assignTable.getColumnModel();
            for (int i = 0; i < this.m_assignTableModel.getColumnCount(); ++i) {
                columnModel.getColumn(i).setCellRenderer(this.m_tableCellRenderer);
            }
        } else {
            this.m_assignTableModel.setData(assignments);
        }
        this.m_assignTableModel.fireTableDataChanged();
        this.m_assignTable.fitColumnsInTable();
    }

    private void setupBeginTimerPanel() {
        this.m_beginTimerPanel = new JPanel();
        this.m_beginTimerPanel.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel nameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_timerNameExpression));
        this.m_beginTimerName = new JTextField();
        this.m_beginTimerName.setEditable(false);
        this.m_beginTimerName.setBorder(null);
        JLabel expirationLabel = new JLabel(VWResource.s_label.toString(VWResource.s_expirationTime));
        this.m_beginTimerExpirationTime = new JTextField();
        this.m_beginTimerExpirationTime.setEditable(false);
        this.m_beginTimerExpirationTime.setBorder(null);
        JLabel mapLabel = new JLabel(VWResource.s_label.toString(VWResource.s_map));
        this.m_beginTimerMap = new JTextField();
        this.m_beginTimerMap.setEditable(false);
        this.m_beginTimerMap.setBorder(null);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.fill = 2;
        panel.add((Component)nameLabel, c);
        c.gridy = -1;
        c.insets = this.insets;
        panel.add((Component)this.m_beginTimerName, c);
        c.insets = this.noInsets;
        panel.add((Component)expirationLabel, c);
        c.insets = this.insets;
        panel.add((Component)this.m_beginTimerExpirationTime, c);
        c.insets = this.noInsets;
        panel.add((Component)mapLabel, c);
        c.insets = this.insets;
        panel.add((Component)this.m_beginTimerMap, c);
        this.m_beginTimerPanel.add((Component)panel, "First");
    }

    private void updateBeginTimerPanel(VWInstructionDefinition instruction) {
        this.setTextField(this.m_beginTimerName, VWInstruction.BeginTimerInstructionGetName(instruction));
        this.setTextField(this.m_beginTimerExpirationTime, VWInstruction.BeginTimerInstructionGetExpirationTime(instruction));
        this.setTextField(this.m_beginTimerMap, VWInstruction.BeginTimerInstructionGetSubmapName(instruction));
    }

    private void setupDbExecutePanel() {
        this.m_dbExecutePanel = new JPanel();
        this.m_dbExecutePanel.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel dbConnectionLabel = new JLabel(VWResource.s_label.toString(VWResource.s_databaseConnectionAlias));
        this.m_dbConnectionAliasName = new JTextField();
        this.m_dbConnectionAliasName.setEditable(false);
        this.m_dbConnectionAliasName.setBorder(null);
        JLabel procedureLabel = new JLabel(VWResource.s_label.toString(VWResource.s_procedureName));
        this.m_dbProcedureName = new JTextField();
        this.m_dbProcedureName.setEditable(false);
        this.m_dbProcedureName.setBorder(null);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.fill = 2;
        panel.add((Component)dbConnectionLabel, c);
        c.gridy = -1;
        c.insets = this.insets;
        panel.add((Component)this.m_dbConnectionAliasName, c);
        c.insets = this.noInsets;
        panel.add((Component)procedureLabel, c);
        c.insets = this.insets;
        panel.add((Component)this.m_dbProcedureName, c);
        VWToolbarBorder fieldsBorder = new VWToolbarBorder(VWResource.s_fields, 0);
        JPanel fieldsPanel = fieldsBorder.getClientPanel();
        fieldsPanel.setLayout(new GridLayout(1, 2, 6, 0));
        this.m_dbExecuteParameterList = new JList();
        JPanel dbParametersPanel = new JPanel(new BorderLayout());
        dbParametersPanel.add((Component)new JScrollPane(this.m_dbExecuteParameterList), "Center");
        fieldsPanel.add(dbParametersPanel);
        c.insets = this.noInsets;
        c.gridy = -1;
        panel.add((Component)fieldsBorder, c);
        this.m_dbExecutePanel.add((Component)panel, "First");
    }

    private void updateDbExecutePanel(VWInstructionDefinition instruction) {
        this.setTextField(this.m_dbConnectionAliasName, VWInstruction.DatabaseExecuteInstructionGetDatabaseName(instruction));
        this.setTextField(this.m_dbProcedureName, VWInstruction.DatabaseExecuteInstructionGetStoredProcName(instruction));
        String[] params = VWInstruction.DatabaseExecuteInstructionGetParameters(instruction);
        if (params != null) {
            this.m_dbExecuteParameterList.setListData(params);
        }
    }

    private void setupCallPanel() {
        this.m_callPanel = new JPanel();
        this.m_callPanel.setLayout(new BorderLayout(10, 10));
        JLabel label = new JLabel(VWResource.s_label.toString(VWResource.s_map));
        this.m_callMap = new JTextField();
        this.m_callMap.setEditable(false);
        this.m_callMap.setBorder(null);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(label);
        panel.add(Box.createHorizontalStrut(6));
        panel.add(this.m_callMap);
        this.m_callPanel.add((Component)panel, "First");
    }

    private void updateCallPanel(VWInstructionDefinition instruction) {
        this.setTextField(this.m_callMap, VWInstruction.CallInstructionGetSubmap(instruction));
    }

    private void setupCreatePanel() {
        this.m_createPanel = new JPanel();
        this.m_createPanel.setLayout(new GridBagLayout());
        JLabel nameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_workflow));
        this.m_createName = new JTextField();
        this.m_createName.setEditable(false);
        this.m_createName.setBorder(null);
        JLabel assignmentsLabel = new JLabel(VWResource.s_label.toString(VWResource.s_assignments));
        this.m_createAssignTable = new VWTable();
        JScrollPane scrollPane = new JScrollPane(this.m_createAssignTable);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.gridwidth = 0;
        c.fill = 2;
        JPanel panel = new JPanel(new BorderLayout(10, 0));
        panel.add((Component)nameLabel, "Before");
        panel.add((Component)this.m_createName, "Center");
        this.m_createPanel.add((Component)panel, c);
        ++c.gridy;
        this.m_createPanel.add((Component)assignmentsLabel, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 0;
        this.m_createPanel.add((Component)scrollPane, c);
    }

    private void updateCreatePanel(VWInstructionDefinition instruction) {
        String workclassName = VWInstruction.CreateInstructionGetWorkClass(instruction);
        this.setTextField(this.m_createName, workclassName);
        String[][] assignments = VWInstruction.CreateInstructionGetAssignments(instruction);
        if (this.m_createAssignTableModel == null) {
            this.m_createAssignTableModel = new AssignTableModel(assignments);
            this.m_createAssignTable.setModel(this.m_createAssignTableModel);
            TableColumnModel columnModel = this.m_createAssignTable.getColumnModel();
            for (int i = 0; i < this.m_createAssignTableModel.getColumnCount(); ++i) {
                columnModel.getColumn(i).setCellRenderer(this.m_tableCellRenderer);
            }
        } else {
            this.m_createAssignTableModel.setData(assignments);
        }
        this.m_createAssignTableModel.fireTableDataChanged();
        this.m_createAssignTable.fitColumnsInTable();
    }

    private void setupDelayPanel() {
        this.m_delayPanel = new JPanel();
        this.m_delayPanel.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(VWResource.s_label.toString(VWResource.s_delayExpression));
        this.m_delayTimeToDelay = new JTextField();
        this.m_delayTimeToDelay.setEditable(false);
        this.m_delayTimeToDelay.setBorder(null);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.fill = 2;
        panel.add((Component)label, c);
        c.gridy = -1;
        c.insets = this.insets;
        panel.add((Component)this.m_delayTimeToDelay, c);
        this.m_delayPanel.add((Component)panel, "First");
    }

    private void updateDelayPanel(VWInstructionDefinition instruction) {
        this.setTextField(this.m_delayTimeToDelay, VWInstruction.DelayInstructionGetTime(instruction));
    }

    private void setupEndTimerPanel() {
        this.m_endTimerPanel = new JPanel();
        this.m_endTimerPanel.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(VWResource.s_label.toString(VWResource.s_timerNameExpression));
        this.m_endTimerName = new JTextField();
        this.m_endTimerName.setEditable(false);
        this.m_endTimerName.setBorder(null);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.fill = 2;
        panel.add((Component)label, c);
        c.gridy = -1;
        c.insets = this.insets;
        panel.add((Component)this.m_endTimerName, c);
        this.m_endTimerPanel.add((Component)panel, "First");
    }

    private void updateEndTimerPanel(VWInstructionDefinition instruction) {
        this.setTextField(this.m_endTimerName, VWInstruction.EndTimerInstructionGetTime(instruction));
    }

    private void setupNoPropPanel() {
        this.m_noPropPanel = new JPanel();
        this.m_noPropPanel.setLayout(new BorderLayout());
        JLabel none = new JLabel(VWResource.s_noParameters);
        none.setHorizontalAlignment(0);
        this.m_noPropPanel.add((Component)none, "Center");
    }

    private void setupExecutePanel() {
        this.m_executePanel = new JPanel();
        this.m_executePanel.setLayout(new GridBagLayout());
        VWToolbarBorder queueNameBorder = new VWToolbarBorder(VWResource.s_queueName, 0);
        JPanel panel = queueNameBorder.getClientPanel();
        panel.setLayout(new BorderLayout());
        this.m_executeQueueName = new JTextField();
        this.m_executeQueueName.setEditable(false);
        this.m_executeQueueName.setBorder(null);
        panel.add((Component)this.m_executeQueueName, "First");
        VWToolbarBorder operationNameBorder = new VWToolbarBorder(VWResource.s_operationName, 0);
        panel = operationNameBorder.getClientPanel();
        panel.setLayout(new BorderLayout());
        this.m_executeOperationName = new JTextField();
        this.m_executeOperationName.setEditable(false);
        this.m_executeOperationName.setBorder(null);
        panel.add((Component)this.m_executeOperationName, "First");
        VWToolbarBorder executeParameterListBorder = new VWToolbarBorder(VWResource.s_operationParameters, 0);
        panel = executeParameterListBorder.getClientPanel();
        panel.setLayout(new BorderLayout());
        this.m_executeParameterList = new JList();
        panel.add((Component)new JScrollPane(this.m_executeParameterList), "First");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.gridwidth = 0;
        c.fill = 1;
        c.anchor = 23;
        this.m_executePanel.add((Component)queueNameBorder, c);
        c.gridy = -1;
        this.m_executePanel.add((Component)operationNameBorder, c);
        c.weighty = 1.0;
        this.m_executePanel.add((Component)executeParameterListBorder, c);
    }

    private void updateExecutePanel(VWInstructionDefinition instruction) {
        this.setTextField(this.m_executeQueueName, VWInstruction.ExecuteInstructionGetQueueName(instruction));
        this.setTextField(this.m_executeOperationName, VWInstruction.ExecuteInstructionGetOperationName(instruction));
        String[] params = VWInstruction.ExecuteInstructionGetParameterList(instruction);
        this.m_executeParameterList.setListData(params);
    }

    private void setupLogPanel() {
        this.m_logPanel = new JPanel();
        this.m_logPanel.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel eventTypeLabel = new JLabel(VWResource.s_label.toString(VWResource.s_eventTypeExpression));
        this.m_eventType = new JTextField();
        this.m_eventType.setEditable(false);
        this.m_eventType.setBorder(null);
        JLabel eventMessageLabel = new JLabel(VWResource.s_label.toString(VWResource.s_eventMessageExpression));
        this.m_eventMessage = new JTextField();
        this.m_eventMessage.setEditable(false);
        this.m_eventMessage.setBorder(null);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.fill = 2;
        panel.add((Component)eventTypeLabel, c);
        c.gridy = -1;
        c.insets = this.insets;
        panel.add((Component)this.m_eventType, c);
        c.insets = this.noInsets;
        panel.add((Component)eventMessageLabel, c);
        c.insets = this.insets;
        panel.add((Component)this.m_eventMessage, c);
        this.m_logPanel.add((Component)panel, "First");
    }

    private void updateLogPanel(VWInstructionDefinition instruction) {
        this.setTextField(this.m_eventType, VWInstruction.LogInstructionGetEventType(instruction));
        this.setTextField(this.m_eventMessage, VWInstruction.LogInstructionGetEventMessage(instruction));
    }

    private void setupResumeTimerPanel() {
        this.m_resumeTimerPanel = new JPanel();
        this.m_resumeTimerPanel.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(VWResource.s_label.toString(VWResource.s_timerNameExpression));
        this.m_resumeTimerName = new JTextField();
        this.m_resumeTimerName.setEditable(false);
        this.m_resumeTimerName.setBorder(null);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.fill = 2;
        panel.add((Component)label, c);
        c.gridy = -1;
        c.insets = this.insets;
        c.fill = 2;
        panel.add((Component)this.m_resumeTimerName, c);
        this.m_resumeTimerPanel.add((Component)panel, "First");
    }

    private void updateResumeTimerPanel(VWInstructionDefinition instruction) {
        this.setTextField(this.m_resumeTimerName, VWInstruction.ResumeTimerInstructionGetTime(instruction));
    }

    private void setupReturnPanel() {
        this.m_returnPanel = new JPanel();
        this.m_returnPanel.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(VWResource.s_label.toString(VWResource.s_returnExpression));
        this.m_returnRetry = new JTextField();
        this.m_returnRetry.setEditable(false);
        this.m_returnRetry.setBorder(null);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.fill = 2;
        panel.add((Component)label, c);
        c.gridy = -1;
        c.insets = this.insets;
        panel.add((Component)this.m_returnRetry, c);
        this.m_returnPanel.add((Component)panel, "First");
    }

    private void updateReturnPanel(VWInstructionDefinition instruction) {
        this.setTextField(this.m_returnRetry, VWInstruction.ReturnInstructionGetRetryOption(instruction));
    }

    private void setupRollbackCheckPointPanel() {
        GridBagConstraints c = null;
        this.m_rollbackCheckPointPanel = new JPanel();
        this.m_rollbackCheckPointPanel.setLayout(new GridBagLayout());
        JLabel resumeProcessingLabel = new JLabel(VWResource.s_label.toString(VWResource.s_resumeProcessingExpression));
        this.m_rollbackResumeProcessingValue = new JTextField();
        this.m_rollbackResumeProcessingValue.setEditable(false);
        this.m_rollbackResumeProcessingValue.setBorder(null);
        JPanel resumePanel = new JPanel(new BorderLayout(10, 10));
        resumePanel.add((Component)resumeProcessingLabel, "Before");
        resumePanel.add((Component)this.m_rollbackResumeProcessingValue, "Center");
        JLabel mapLabel = new JLabel(VWResource.s_label.toString(VWResource.s_map));
        this.m_rollbackMap = new JTextField();
        this.m_rollbackMap.setEditable(false);
        this.m_rollbackMap.setBorder(null);
        JPanel mapPanel = new JPanel(new BorderLayout(10, 10));
        mapPanel.add((Component)mapLabel, "Before");
        mapPanel.add((Component)this.m_rollbackMap, "Center");
        VWToolbarBorder fieldsBorder = new VWToolbarBorder(VWResource.s_fields, 0);
        JPanel panel = fieldsBorder.getClientPanel();
        panel.setLayout(new GridLayout(1, 2, 6, 0));
        this.m_rolledBackUserFields = new JList();
        this.m_nonRolledBackUserFields = new JList();
        JPanel rollBackPanel = new JPanel(new BorderLayout());
        rollBackPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_rollBack)), "First");
        rollBackPanel.add((Component)new JScrollPane(this.m_rolledBackUserFields), "Center");
        JPanel nonRollBackPanel = new JPanel(new BorderLayout());
        nonRollBackPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_nonRollBack)), "First");
        nonRollBackPanel.add((Component)new JScrollPane(this.m_nonRolledBackUserFields), "Center");
        panel.add(rollBackPanel);
        panel.add(nonRollBackPanel);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 23;
        c.fill = 2;
        c.gridwidth = 0;
        this.m_rollbackCheckPointPanel.add((Component)resumePanel, c);
        c.gridy = -1;
        this.m_rollbackCheckPointPanel.add((Component)mapPanel, c);
        c.fill = 1;
        c.weighty = 0.5;
        this.m_rollbackCheckPointPanel.add((Component)fieldsBorder, c);
    }

    private void updateRollbackCheckPointPanel(VWInstructionDefinition instruction) {
        String[] nonRollBackedFields = null;
        Vector<String> rollBackedFields = new Vector<String>();
        this.setTextField(this.m_rollbackResumeProcessingValue, VWInstruction.RollBackCheckPointInstructionGetReDoFlag(instruction));
        nonRollBackedFields = VWInstruction.RollBackCheckPointInstructionGetNonRolledBackFieldList(instruction);
        this.m_nonRolledBackUserFields.setListData(nonRollBackedFields);
        this.setTextField(this.m_rollbackMap, VWInstruction.RollBackCheckPointInstructionGetMap(instruction));
        if (this.m_allDataFields == null) {
            VWTrkDataModel dataModel = this.m_propPanel.getDataModel();
            VWWorkflowDefinition def = dataModel.getWorkflowDefinition();
            try {
                this.m_allDataFields = def.getFields();
                for (int i = 0; i < this.m_allDataFields.length; ++i) {
                    String name = this.m_allDataFields[i].getName();
                    if (name.length() < 2 || name.charAt(0) != 'F' || name.charAt(1) != '_') continue;
                    this.m_allDataFields[i] = null;
                }
            }
            catch (VWException ex) {
                // empty catch block
            }
        }
        if (this.m_allDataFields != null && this.m_allDataFields.length > 0) {
            int i;
            for (i = 0; i < this.m_allDataFields.length; ++i) {
                if (this.m_allDataFields[i] == null || this.m_allDataFields[i].getName() == null) continue;
                rollBackedFields.add(this.m_allDataFields[i].getName());
            }
            block4: for (i = 0; i < nonRollBackedFields.length; ++i) {
                String name1 = nonRollBackedFields[i];
                if (name1 == null) continue;
                for (int j = 0; j < rollBackedFields.size(); ++j) {
                    String name2 = (String)rollBackedFields.elementAt(j);
                    if (name2 == null || VWStringUtils.compare(name1, name2) != 0) continue;
                    rollBackedFields.removeElementAt(j);
                    continue block4;
                }
            }
        }
        this.m_rolledBackUserFields.setListData(rollBackedFields);
    }

    private void setupSuspendTimerPanel() {
        this.m_suspendTimerPanel = new JPanel();
        this.m_suspendTimerPanel.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(VWResource.s_label.toString(VWResource.s_timerNameExpression));
        this.m_suspendTimerName = new JTextField();
        this.m_suspendTimerName.setEditable(false);
        this.m_suspendTimerName.setBorder(null);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.fill = 2;
        panel.add((Component)label, c);
        c.gridy = -1;
        c.insets = this.insets;
        panel.add((Component)this.m_suspendTimerName, c);
        this.m_suspendTimerPanel.add((Component)panel, "First");
    }

    private void updateSuspendTimerPanel(VWInstructionDefinition instruction) {
        this.setTextField(this.m_suspendTimerName, VWInstruction.SuspendTimerInstructionGetTime(instruction));
    }

    private void setupWaitForEventPanel() {
        this.m_waitForEventPanel = new JPanel();
        this.m_waitForEventPanel.setLayout(new GridBagLayout());
        JLabel timeoutLabel = new JLabel(VWResource.s_label.toString(VWResource.s_timeout));
        this.m_waitForEventTimeout = new JTextField();
        this.m_waitForEventTimeout.setEditable(false);
        this.m_waitForEventTimeout.setBorder(null);
        JPanel timeoutPanel = new JPanel(new BorderLayout(10, 0));
        timeoutPanel.add((Component)timeoutLabel, "Before");
        timeoutPanel.add((Component)this.m_waitForEventTimeout, "Center");
        JLabel resultDataFieldLabel = new JLabel(VWResource.s_label.toString(VWResource.s_fieldForConditionResult));
        this.m_resultDataField = new JTextField();
        this.m_resultDataField.setEditable(false);
        this.m_resultDataField.setBorder(null);
        JPanel resultDataFieldPanel = new JPanel(new BorderLayout(10, 0));
        resultDataFieldPanel.add((Component)resultDataFieldLabel, "Before");
        resultDataFieldPanel.add((Component)this.m_resultDataField, "Center");
        VWToolbarBorder eventBorder = new VWToolbarBorder(VWResource.s_conditions, 0);
        JPanel eventPanel = eventBorder.getClientPanel();
        eventPanel.setLayout(new BorderLayout());
        eventPanel.setBorder(BorderFactory.createEtchedBorder());
        this.m_waitForEventEventTable = new VWTable();
        this.m_waitForEventEventTable.setRowSelectionAllowed(true);
        this.m_waitForEventEventTable.setColumnSelectionAllowed(false);
        this.m_waitForEventEventTable.setSelectionMode(0);
        this.m_waitForEventEventTable.getSelectionModel().addListSelectionListener(this);
        eventPanel.add((Component)new JScrollPane(this.m_waitForEventEventTable), "Center");
        VWToolbarBorder actionBorder = new VWToolbarBorder(VWResource.s_actions, 0);
        JPanel actionPanel = actionBorder.getClientPanel();
        actionPanel.setLayout(new GridBagLayout());
        JLabel mapLabel = new JLabel(VWResource.s_label.toString(VWResource.s_map));
        this.m_waitForEventMap = new JTextField();
        this.m_waitForEventMap.setEditable(false);
        this.m_waitForEventMap.setBorder(null);
        JPanel mapPanel = new JPanel(new BorderLayout(10, 0));
        mapPanel.add((Component)mapLabel, "Before");
        mapPanel.add((Component)this.m_waitForEventMap, "Center");
        JLabel assignmentsLabel = new JLabel(VWResource.s_label.toString(VWResource.s_fieldAssignments));
        this.m_waitForEventAssignTable = new VWTable();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 23;
        c.gridwidth = 0;
        c.weighty = 0.0;
        c.fill = 2;
        actionPanel.add((Component)assignmentsLabel, c);
        c.gridy = -1;
        c.weighty = 1.0;
        c.fill = 1;
        actionPanel.add((Component)new JScrollPane(this.m_waitForEventAssignTable), c);
        c.weighty = 0.0;
        c.fill = 2;
        actionPanel.add((Component)mapPanel, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 23;
        c.gridwidth = 0;
        c.fill = 2;
        this.m_waitForEventPanel.add((Component)timeoutPanel, c);
        c.gridy = -1;
        this.m_waitForEventPanel.add((Component)resultDataFieldPanel, c);
        c.fill = 1;
        c.weighty = 1.0;
        this.m_waitForEventPanel.add((Component)eventBorder, c);
        this.m_waitForEventPanel.add((Component)actionBorder, c);
    }

    private void updateWaitForEventPanel(VWInstructionDefinition instruction) {
        String timeout = VWInstruction.WaitForEventInstructionGetTimeOut(instruction);
        if (timeout == null || VWStringUtils.compare(timeout, "0") == 0) {
            this.setTextField(this.m_waitForEventTimeout, VWResource.s_neverExpires);
        } else {
            this.setTextField(this.m_waitForEventTimeout, timeout);
        }
        this.setTextField(this.m_resultDataField, VWInstruction.WaitForEventInstructionGetEventNumLoc(instruction));
        this.m_waitForEventEvents = VWInstruction.WaitForEventInstructionGetEvents(instruction);
        if (this.m_waitForEventEvents != null) {
            if (this.m_waitForEventEventTableModel == null) {
                this.m_waitForEventEventTableModel = new AbstractTableModel(){

                    public boolean isCellEditable(int row, int col) {
                        return false;
                    }

                    public String getColumnName(int col) {
                        if (col >= 0 && col < VWSystemStepGeneralPanel.this.m_eventTableColumnNames.length) {
                            return VWSystemStepGeneralPanel.this.m_eventTableColumnNames[col];
                        }
                        return null;
                    }

                    public int getColumnCount() {
                        return VWSystemStepGeneralPanel.this.m_eventTableColumnNames.length;
                    }

                    public int getRowCount() {
                        if (VWSystemStepGeneralPanel.this.m_waitForEventEvents != null) {
                            return VWSystemStepGeneralPanel.this.m_waitForEventEvents.length;
                        }
                        return 0;
                    }

                    public Object getValueAt(int row, int col) {
                        if (VWSystemStepGeneralPanel.this.m_waitForEventEvents != null && row >= 0 && row < VWSystemStepGeneralPanel.this.m_waitForEventEvents.length) {
                            VWEventDefinition event = VWSystemStepGeneralPanel.this.m_waitForEventEvents[row];
                            String workclass = event.getWorkClassName();
                            switch (col) {
                                case 0: {
                                    return new Integer(row + 1);
                                }
                                case 1: {
                                    return workclass;
                                }
                                case 2: {
                                    if (workclass != null && workclass.length() > 0) {
                                        try {
                                            String condition = VWDefaultSessionProxy.getSession().fetchWorkflowSignature(workclass).getFTagExpression();
                                            condition = condition + event.getComparisonOperator();
                                            condition = condition + " ";
                                            condition = condition + event.getValue();
                                            return condition;
                                        }
                                        catch (Exception ex) {
                                            // empty catch block
                                        }
                                    }
                                    return null;
                                }
                            }
                        }
                        return null;
                    }
                };
                this.m_waitForEventEventTable.setModel(this.m_waitForEventEventTableModel);
            }
            this.m_waitForEventEventTableModel.fireTableDataChanged();
            this.m_waitForEventEventTable.fitColumnsInTable();
            this.m_waitForEventEventTable.updateUI();
            if (this.m_waitForEventEvents.length > 0) {
                this.m_waitForEventEventTable.setRowSelectionInterval(0, 0);
            }
        }
        this.m_waitForEventPanel.updateUI();
    }

    private void setupWaitForEventEventTable() {
        FontMetrics fm = null;
        Font font = this.getFont();
        if (font != null) {
            fm = this.getFontMetrics(font);
        }
        TableColumnModel columnModel = this.m_waitForEventEventTable.getColumnModel();
        TableColumn envetNumberColumn = columnModel.getColumn(0);
        envetNumberColumn.setCellRenderer(this.m_tableCellRenderer);
        envetNumberColumn.setMinWidth(20);
        envetNumberColumn.setMaxWidth(20);
        if (fm != null) {
            int width = fm.stringWidth(this.m_eventTableColumnNames[0]);
            int w = fm.stringWidth("0") * 2;
            width = Math.max(w, width);
            if (width != 0) {
                envetNumberColumn.setMaxWidth(width += 10);
                envetNumberColumn.setPreferredWidth(width);
            }
        }
        TableColumn nameColumn = columnModel.getColumn(1);
        nameColumn.setHeaderRenderer(new VWTableHeaderRenderer(this.m_eventTableColumnNames[1], this.m_waitedForWorkflowIcon, VWResource.s_waitedForWorkflowName));
        nameColumn.setCellRenderer(this.m_tableCellRenderer);
        columnModel.getColumn(2).setCellRenderer(this.m_tableCellRenderer);
    }

    private void updateWaitForEventSelection() {
        int index;
        if (this.m_waitForEventEventTable != null && this.m_waitForEventEvents != null && (index = this.m_waitForEventEventTable.getSelectedRow()) >= 0 && index < this.m_waitForEventEvents.length) {
            VWEventDefinition event = this.m_waitForEventEvents[index];
            this.setTextField(this.m_waitForEventMap, event.getCallISName());
            String[][] waitForEventAssignments = event.getAssignments();
            if (this.m_waitForEventAssignTableModel == null) {
                this.m_waitForEventAssignTableModel = new AssignTableModel(waitForEventAssignments);
                this.m_waitForEventAssignTable.setModel(this.m_waitForEventAssignTableModel);
                TableColumnModel columnModel = this.m_waitForEventAssignTable.getColumnModel();
                for (int i = 0; i < this.m_waitForEventAssignTableModel.getColumnCount(); ++i) {
                    columnModel.getColumn(i).setCellRenderer(this.m_tableCellRenderer);
                }
            } else {
                this.m_waitForEventAssignTableModel.setData(waitForEventAssignments);
            }
            this.setupWaitForEventEventTable();
            this.m_waitForEventAssignTableModel.fireTableDataChanged();
            this.m_waitForEventAssignTable.fitColumnsInTable();
            this.m_waitForEventAssignTable.updateUI();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (e.getSource() == this.m_functionList) {
                this.updateFunctionPropertyPanel();
            } else if (this.m_waitForEventEventTable != null && e.getSource() == this.m_waitForEventEventTable.getSelectionModel()) {
                this.updateWaitForEventSelection();
            }
        }
    }

    protected VWSchema getSchemaFromWorkflow(String name) {
        try {
            VWTrkDataModel dataModel = this.m_propPanel.getDataModel();
            VWWorkflowDefinition def = dataModel.getWorkflowDefinition();
            if (def != null && name != null && name.length() > 0) {
                return def.getSchema(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected Object getTypeFromParam(VWWebServiceParameterDefinition paramDef) {
        try {
            if (paramDef != null) {
                if (paramDef.getDataType() == 32 && paramDef.isAttachmentByValue()) {
                    if (paramDef.getIsArray()) {
                        return ATTACH_BY_VALUE_ARRAY;
                    }
                    return ATTACH_BY_VALUE;
                }
                StringBuffer buffer = new StringBuffer(VWFieldType.getLocalizedString(paramDef.getDataType()));
                if (paramDef.getIsArray()) {
                    buffer.append(ARRAY);
                }
                return buffer.toString();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    protected void setTextField(JTextField field, String text) {
        if (text == null) {
            field.setText(VWResource.s_none);
        } else {
            field.setText(text);
            field.setToolTipText(VWStringUtils.formatToolTip(text, 0));
        }
        field.updateUI();
        field.setBorder(null);
    }

    protected void setupTableCellRenderer(VWTable table, AbstractTableModel tableModel) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setCellRenderer(this.m_tableCellRenderer);
        }
    }

    private void initFunctionModel() {
        if (this.m_functionListModel == null) {
            this.m_functionListModel = new DefaultListModel();
        }
        this.m_functionListModel.removeAllElements();
        if (this.m_functions != null && this.m_functions.length > 0) {
            for (int index = 0; index < this.m_functions.length; ++index) {
                this.m_functionListModel.addElement(this.m_functions[index]);
            }
        }
    }

    public void removeReferences() {
        int i;
        this.m_mapNode = null;
        if (this.m_functionListModel != null) {
            this.m_functionListModel.removeAllElements();
            this.m_functionListModel = null;
        }
        if (this.m_functionList != null) {
            this.m_functionList.setModel(null);
            this.m_functionList.setCellRenderer(null);
            this.m_functionList = null;
        }
        if (this.m_functionPropertyBorder != null) {
            this.m_functionPropertyBorder.removeAll();
            this.m_functionPropertyBorder = null;
        }
        this.m_functionPropertyPanel = null;
        this.m_tableCellRenderer = null;
        this.m_waitedForWorkflowIcon = null;
        if (this.m_noPropPanel != null) {
            this.m_noPropPanel.removeAll();
            this.m_noPropPanel = null;
        }
        if (this.m_assignPanel != null) {
            this.m_assignPanel.removeAll();
            this.m_assignPanel = null;
        }
        if (this.m_assignTable != null) {
            this.m_assignTable.removeReferences();
            this.m_assignTable = null;
        }
        if (this.m_assignTableModel != null) {
            this.m_assignTableModel.setData(null);
            this.m_assignTableModel = null;
        }
        for (i = 0; i < this.m_assignColumnNames.length; ++i) {
            this.m_assignColumnNames[i] = null;
        }
        this.m_assignColumnNames = null;
        if (this.m_beginTimerPanel != null) {
            this.m_beginTimerPanel.removeAll();
            this.m_beginTimerPanel = null;
        }
        this.m_beginTimerName = null;
        this.m_beginTimerExpirationTime = null;
        this.m_beginTimerMap = null;
        if (this.m_dbExecutePanel != null) {
            this.m_dbExecutePanel.removeAll();
            this.m_dbExecutePanel = null;
        }
        this.m_dbConnectionAliasName = null;
        this.m_dbProcedureName = null;
        this.m_dbExecuteParameterList = null;
        if (this.m_callPanel != null) {
            this.m_callPanel.removeAll();
            this.m_callPanel = null;
        }
        this.m_callMap = null;
        this.m_createPanel = null;
        if (this.m_createAssignTable != null) {
            this.m_createAssignTable.removeReferences();
            this.m_createAssignTable = null;
        }
        if (this.m_createAssignTableModel != null) {
            this.m_createAssignTableModel.setData(null);
            this.m_createAssignTableModel = null;
        }
        this.m_createName = null;
        for (i = 0; i < this.m_createAssignColumnNames.length; ++i) {
            this.m_createAssignColumnNames[i] = null;
        }
        this.m_createAssignColumnNames = null;
        if (this.m_delayPanel != null) {
            this.m_delayPanel.removeAll();
            this.m_delayPanel = null;
        }
        this.m_delayTimeToDelay = null;
        if (this.m_endTimerPanel != null) {
            this.m_endTimerPanel.removeAll();
            this.m_endTimerPanel = null;
        }
        this.m_endTimerName = null;
        if (this.m_resumeTimerPanel != null) {
            this.m_resumeTimerPanel.removeAll();
            this.m_resumeTimerPanel = null;
        }
        this.m_resumeTimerName = null;
        if (this.m_returnPanel != null) {
            this.m_returnPanel.removeAll();
            this.m_returnPanel = null;
        }
        this.m_returnRetry = null;
        if (this.m_suspendTimerPanel != null) {
            this.m_suspendTimerPanel.removeAll();
            this.m_suspendTimerPanel = null;
        }
        this.m_suspendTimerName = null;
        if (this.m_rollbackCheckPointPanel != null) {
            this.m_rollbackCheckPointPanel.removeAll();
            this.m_rollbackCheckPointPanel = null;
        }
        this.m_rollbackResumeProcessingValue = null;
        this.m_rolledBackUserFields = null;
        this.m_nonRolledBackUserFields = null;
        this.m_rollbackMap = null;
        this.m_allDataFields = null;
        if (this.m_executePanel != null) {
            this.m_executePanel.removeAll();
            this.m_executePanel = null;
        }
        this.m_executeQueueName = null;
        this.m_executeOperationName = null;
        this.m_executeParameterList = null;
        for (i = 0; i < this.m_eventTableColumnNames.length; ++i) {
            this.m_eventTableColumnNames[i] = null;
        }
        this.m_eventTableColumnNames = null;
        if (this.m_waitForEventPanel != null) {
            this.m_waitForEventPanel.removeAll();
            this.m_waitForEventPanel = null;
        }
        this.m_waitForEventTimeout = null;
        this.m_resultDataField = null;
        if (this.m_waitForEventEventTable != null) {
            this.m_waitForEventEventTable.removeReferences();
            this.m_waitForEventEventTable = null;
        }
        this.m_waitForEventEventTableModel = null;
        this.m_waitForEventEvents = null;
        this.m_waitForEventMap = null;
        if (this.m_waitForEventAssignTable != null) {
            this.m_waitForEventAssignTable.removeReferences();
            this.m_waitForEventAssignTable = null;
        }
        if (this.m_waitForEventAssignTableModel != null) {
            this.m_waitForEventAssignTableModel.setData(null);
            this.m_waitForEventAssignTableModel = null;
        }
        if (this.m_invokeParamPanel != null) {
            this.m_invokeParamPanel.removeReferences();
            this.m_invokeParamPanel = null;
        }
        if (this.m_receiveParamPanel != null) {
            this.m_receiveParamPanel.removeReferences();
            this.m_receiveParamPanel = null;
        }
        if (this.m_replyParamPanel != null) {
            this.m_replyParamPanel.removeReferences();
            this.m_replyParamPanel = null;
        }
    }

    private class AssignTableModel
    extends AbstractTableModel {
        String[][] m_data = null;

        public AssignTableModel(String[][] data) {
            this.m_data = data;
        }

        public void setData(String[][] data) {
            this.m_data = data;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public String getColumnName(int col) {
            if (col >= 0 && col < VWSystemStepGeneralPanel.this.m_assignColumnNames.length) {
                return VWSystemStepGeneralPanel.this.m_assignColumnNames[col];
            }
            return null;
        }

        public int getColumnCount() {
            return VWSystemStepGeneralPanel.this.m_assignColumnNames.length;
        }

        public int getRowCount() {
            if (this.m_data != null) {
                int length = this.m_data.length;
                return length;
            }
            return 0;
        }

        public Object getValueAt(int row, int col) {
            if (this.m_data != null && row >= 0 && row < this.m_data.length && row >= 0 && row < this.m_data.length && col >= 0 && col < VWSystemStepGeneralPanel.this.m_assignColumnNames.length) {
                return this.m_data[row][col];
            }
            return null;
        }
    }
}

